%------------------------------------------------------------------------------
% File     : SEU469^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Set Theory (Binary relations)
% Problem  : Transitive reflexive closure is transitive and reflexive
% Version  : [Nei08] axioms.
% English  : The transitive reflexive closure of a binary relation is
%            transitive and reflexive.

% Refs     : [BN99]  Baader & Nipkow (1999), Term Rewriting and All That
%          : [Nei08] Neis (2008), Email to Geoff Sutcliffe
% Source   : [Nei08]
% Names    :

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.33 v7.2.0, 0.25 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.29 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.1.0, 0.60 v5.0.0, 0.40 v4.1.0, 0.67 v3.7.0
% Syntax   : Number of formulae    :   59 (   0 unit;  29 type;  29 defn)
%            Number of atoms       :  255 (  33 equality; 160 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :  163 (   4   ~;   4   |;  13   &; 126   @)
%                                         (   0 <=>;  16  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   31 (  29   :;   0   =)
%            Number of variables   :   87 (   0 sgn;  39   !;   5   ?;  43   ^)
%                                         (  87   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Some proofs can be found in chapter 2 of [BN99]
%          : 
%------------------------------------------------------------------------------
%----Include axioms of binary relations
include('Axioms/SET009^0.ax').
%------------------------------------------------------------------------------
thf(transitive_reflexive_closure_is_transitive_reflexive,conjecture,(
    ! [R: $i > $i > $o] :
      ( ( trans @ ( trc @ R ) )
      & ( refl @ ( trc @ R ) ) ) )).

%------------------------------------------------------------------------------
